function [pivots_out,centroid_img,lum_img] = find_centroid2d(varargin)
%This function is used to find the 2d centroid of a set of images.
%Synatax:   [pivots,centroid_img,lum_img] = find_centroid2d('imgs',array,
%                               'theshold',0.5,'type',2,'type2',1,'norm',1)
%Input:     'imgs' = stacks to be processed. in a horizontal cell array (no
%                    longer supported, if you want this roll back to
%                    version 3.5)
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%.  Now
%               the function will allow you to iterate through a number of
%               threshold you enter, essentially in the format:
%               (0.1,0.05...)
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max), 
%               default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity, 4(Pixel #)
%                   default = 0(Mean Intensity) Note: only works with
%                   centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements, now matches threshold.
%           object = out put the images of the objects.  Default = 0(off)
%               Does not work with local max
%Output:    pivots = a x by 4 array, where x y z define the pivots
%               and the brightness of the centroid is the 4th column.
%           centroid_img = the stacks reduced to the centroids.
%           lum_img = the points with the actual brightness levels for each
%               local max

[threshold,imgs_ch_names,channel_paths,type,type2,norm,filterindex,object] = parse(varargin);

%initiate labeling of matrix (happy now?!)
mxlabel = {'x','y'};
%lets get straight on calculating the local max
h = waitbar(0,'Processing: ','position',[10 50 275 50]);
pivots_all = [];
for i = 1:size(imgs_ch_names,2)
    %open the stack, no need to cell mode
    %warning('OFF')      %the progress bars will trigger warnings in parallel mode.
    [imgs] = stack_gui('filename',imgs_ch_names{1,i},'pathname',channel_paths,'filterindex',filterindex);
    %warning('ON')
    img_tmp = imgs;        %make a copy of the stack to work on.
    for m = 1:size(threshold,2)     %iterate for number of threshold
        waitbar(i/size(imgs_ch_names,2),h,['Processing: ',imgs_ch_names{1,i},' at threshold: ',num2str(threshold(m))]);   %update progress
        %normalize, only if needed
        if m==1||norm(m)~=norm(m-1)
            if norm(m)==1  %normalize
                img_tmp = imnorm(img_tmp);    %normalize the image so that the bit depth is maximized.
            elseif norm(m)>0 && norm(m)<1     %imadjust mode
                lo_hi = stretchlim(max(img_tmp,[],3),[0 norm(m)]);   %generate the contrast range
                for l = 1:size(img_tmp,3)   %enhance each image
                    img_tmp(:,:,l) = imadjust(img_tmp(:,:,l),lo_hi,[]);
                end
            end
        end
        if ~type        %default (local max)
            local_max_tmp = [];
            %create the actual threshold, which is percentage between the max and the
            %min of each image.
            thresh_tmp = absmax(imgs)*threshold(m);
            img_tmp(img_tmp<thresh_tmp) = 0;
            centroid_img = imregionalmax(img_tmp);
        else
            img_bw = false(size(img_tmp));
            for j = 1:size(imgs,3)     %make the img Black & White
                img_bw(:,:,j) = im2bw(img_tmp(:,:,j),threshold(m));
            end
            img_cc = bwconncomp(img_bw);    %run the connected components analysis
            switch type
                case 1    %Centroid
                    pivots = regionprops(img_cc,'Centroid');  %find centroid
                    %pivots_out_tmp = cat(1,pivots.Centroid);
                case 2    %WeightedCentroid
                    pivots = regionprops(img_cc,imgs,'WeightedCentroid');
                    %pivots_out_tmp = cat(1,pivots.WeightedCentroid);
            end
            lum = [];
            for o = 1:size(type2,2)
                switch type2(o)
                    case 1      %area
                        lum_tmp = regionprops(img_cc,'Area');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1 %do this once
                            mxlabel = [mxlabel 'Area']; %generate the label in order
                        end
                    case 2      %max intensity
                        lum_tmp = regionprops(img_cc,imgs,'MaxIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1
                            mxlabel = [mxlabel 'MaxIntensity'];
                        end
                    case 3      %min intensity
                        lum_tmp = regionprops(img_cc,imgs,'MinIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1
                            mxlabel = [mxlabel 'MinIntensity'];
                        end
                    case 4      %Pixel Number
                        lum_tmp = regionprops(img_cc,'PixelIdxList');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = size(lum_tmp{l},1); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1
                            mxlabel = [mxlabel 'VoxelNumber'];
                        end
                    case 5      %Intensity Integrated
                        lum_tmp = regionprops(img_cc,imgs,'PixelValue');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = sum(lum_tmp{l}); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1
                            mxlabel = [mxlabel 'IntegratedIntensity'];
                        end
                    otherwise
                        lum_tmp = regionprops(img_cc,imgs,'MeanIntensity');    %find the intensity of the regions
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                        if i==1&&m==1
                            mxlabel = [mxlabel 'MeanIntensity'];
                        end
                end
                lum_tmp = [];
            end
            centroid_tmp = false(size(imgs));  %create a logical array the same size as the original array
            %pivots is currently a structure, convert to cell then matrix
            pivots = cell2mat(struct2cell(pivots)');
            %now make the pivots output by adding lum
            pivots_out_tmp = [pivots lum];
            %one consolidated pivots list
            pivots_all = vertcat(pivots_all,horzcat(pivots,repmat(i,[size(pivots,1),1]))); %add the slice marker as an index of image number
            %round pivots to use as pixel indexs
            pivots = round(pivots);
            %now calculate the indexs for the centroid locations
            [x,y,z] = size(centroid_tmp);        %stack size
            pivots_idx = ((pivots(:,1)-1).*x)+pivots(:,2);
            %modify img_tmp
            centroid_tmp(pivots_idx) = 1;
            %         pivots_out_tmp = zeros(size(pivots,1),(3+size(lum,2)));
            %         for k = 1:size(pivots,1)    %go through the pivots list
            %             switch type
            %                 case 1      %Centroid
            %                     img_tmp(round(pivots(k).Centroid(1,2)),round(pivots(k).Centroid(1,1)),round(pivots(k).Centroid(1,3))) = 1;  %make centroid_img image
            %                     %lum_tmp = single(imgs{1,i}(round(pivots(k).Centroid(1,2)),round(pivots(k).Centroid(1,1)),round(pivots(k).Centroid(1,3))));
            %                     %pivots_out_tmp(k,:) = [pivots(k).Centroid lum_tmp];
            %                     pivots_out_tmp(k,:) = [pivots(k).Centroid lum(k,:)];
            %                 case 2      %Weighted Centroid
            %                     img_tmp(round(pivots(k).WeightedCentroid(1,2)),round(pivots(k).WeightedCentroid(1,1)),round(pivots(k).WeightedCentroid(1,3))) = 1;  %make centroid_img image
            %                     %lum_tmp = single(imgs{1,i}(round(pivots(k).WeightedCentroid(1,2)),round(pivots(k).WeightedCentroid(1,1)),round(pivots(k).WeightedCentroid(1,3))));
            %                     %pivots_out_tmp(k,:) = [pivots(k).WeightedCentroid lum_tmp];
            %                     pivots_out_tmp(k,:) = [pivots(k).WeightedCentroid lum(k,:)];
            %             end
            %         end
            centroid_img = centroid_tmp;
            pivots_out = pivots_out_tmp;
            imgclass = class(imgs);      %get image type
            if object   %if object is on
                object_idx = cell2mat(struct2cell(regionprops(img_cc,'PixelIdxList'))');    %grab the indexs of all of the pixels
                object_tmp = false(size(imgs));    %stack holder
                object_tmp(object_idx) = 1;     %create the image
                object_img = object_tmp;   %store
                switch imgclass
                    case 'uint8'
                        object_lum = imgs.*uint8(object_img);   %preserve the luminance.
                    case 'uint16'
                        object_lum = imgs.*uint16(object_img);   %preserve the luminance.
                    case 'uint32'
                        object_lum = imgs.*uint32(object_img);   %preserve the luminance.
                    case 'double'
                        object_lum = imgs.*double(object_img);   %preserve the luminance.
                end
                object_tmp = []; %clear!
            end
            %clear img_tmp pivots_out_tmp img_bw
            pivots_out_tmp = [];img_cc = [];centroid_tmp = [];
        end
        %Now pickup the brightness at the max
        switch imgclass
            case 'uint8'
                lum_img = imgs.*uint8(centroid_img);
            case 'uint16'
                lum_img = imgs.*uint16(centroid_img);
            case 'uint32'
                lum_img = imgs.*uint32(centroid_img);
            case 'double'
                lum_img = imgs.*double(centroid_img);
        end
        
        %Now write the data out to a file and clear the memory
        if ~type   %if local max
            for j = 1:size(centroid_img,3)
                [x_tmp,y_tmp] = find(centroid_img(:,:,j)>0);
                lm_cache = [x_tmp y_tmp repmat(j,size(x_tmp,1),1)];
                local_max_tmp = vertcat(local_max_tmp,lm_cache);
            end
            lum_tmp = double(lum_img(centroid_img));
            pivots_out = [local_max_tmp lum_tmp];
            if i==1&&m==1
                mxlabel = [mxlabel 'LocalIntensity'];
            end
        end
        %dynamic path
        if i==1     %do this only once
            switch type
                case 0
                    dir_path{m} = ['LocalMaxs',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'n',num2str(norm(m)),filesep];     %where to save it
                    object = 0;     %force this, because local max has no object
                case 1
                    dir_path{m} = ['Centroids',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'n',num2str(norm(m)),filesep];     %where to save it
                case 2
                    dir_path{m} = ['WeightedCentroids',datestr(now,'yyyymmdd.HHMM'),'_t',num2str(threshold(m)),'n',num2str(norm(m)),filesep];     %where to save it
            end
            mkdir(channel_paths,dir_path{m});      %create output directory
            mkdir(channel_paths,[dir_path{m},'img_data',filesep]);     %create a directory where the file information is stored
        end
        %now save the files
        warning('OFF')
        mkdir([channel_paths,dir_path{m}],imgs_ch_names{1,i}(1:end-4));
        xls_exp = dataset({pivots_out,mxlabel{:}});               %to export as a XLS need to make the data a dataset.
        %export(xls_exp,'XLSfile',[[channel_paths,dir_path{m}],[imgs_ch_names{1,i},'.xls']]);
        export(xls_exp,'File',[[channel_paths,dir_path{m}],[imgs_ch_names{1,i}(1:end-4),'.',num2str(size(pivots_out,1)),'.csv']],'delimiter',',')
        mkdir([channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4)],['lum_imgs',filesep]);
        stk2tiff(lum_img,imgs_ch_names{1,i},[channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4),filesep,'lum_imgs',filesep]);
        mkdir([channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4)],['centroid_imgs',filesep]);
        stk2tiff(centroid_img,imgs_ch_names{1,i},[channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4),filesep,'centroid_imgs',filesep]);
        if object   %save out the object stacks
            mkdir([channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4)],['objects_lum',filesep]);
            stk2tiff(object_lum,imgs_ch_names{1,i},[channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4),filesep,'objects_lum',filesep]);
            mkdir([channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4)],['objects',filesep]);
            stk2tiff(object_img,imgs_ch_names{1,i},[channel_paths,dir_path{m},imgs_ch_names{1,i}(1:end-4),filesep,'objects',filesep]);
        end
        %save some info about the image
        img_data = size(imgs);
        img_data = dataset(img_data);
        export(img_data,'File',[[channel_paths,dir_path{m},'img_data',filesep],imgs_ch_names{1,i}(1:end-4),'_img_data.csv'],'delimiter',',')
        %clear data
        local_max_tmp = []; lum_tmp = []; xls_exp = [];centroid_img = [];lum_img = [];object_img = [];object_lum = [];pivots_out = [];
        if i==1
            %for historical reasons I am going to do this, just one more file no big
            export(img_data,'File',[[channel_paths,dir_path{m},'img_data',filesep],'img_data.csv'],'delimiter',',')
        end
        warning('ON')
    end
    img_tmp = [];imgs = [];
end
all_data = dataset(pivots_all);               %to export as a XLS need to make the data a dataset.
export(all_data,'File',[[channel_paths],['all_centroids.',num2str(size(pivots_all,1)),'.csv']],'delimiter',',')
close(h)

%matlabpool close

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,imgs_ch_names,channel_paths,type,type2,norm,filterindex,object] = parse(input)

threshold = [];    
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 1;
object = 0;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the stacks you want to open
[imgs_ch_names,channel_paths,filterindex] = uigetfile2({'*.tif','TIFF files (*.tif)';...
    '*.jpg','Jpeg files (*.jpg)';'*.gif','GIF files (*.gif)';...
    '*.bmp','Bitmap files (*.bmp)';'*.mat','Mat files (*.mat)';},'Open Images','Multiselect','on');
%set threshold, if the user have not already.
if isempty(threshold)
    switch type
        case 0   %default local max
            threshold = 0.1;
        otherwise  %centroid or weighted centroid
            threshold = 0.1;
    end
end
%make sure treshold and norm line up
if size(threshold,2)~=size(norm,2)   %align zfilter to threshold
    diff = size(threshold,2)-size(norm,2);   %the difference
    norm = horzcat(norm,ones(1,diff));   %pad with default
end
% %create the actual threshold, which is percentage between the max and the
% %min of each image.
% if ~isempty(threshold) && ~type
%     for i = 1:size(imgs,2)
%         thresh_tmp{1,i} = absmax(imgs{1,i})*threshold;
%     end
%     threshold = thresh_tmp;
% end

%make sure the file names are in a cell array
if ~iscell(imgs_ch_names)
    imgs_ch_names = {imgs_ch_names};
end